// Listing 9-7

import java.util.Scanner;

public class Listing9_7
{
   public static void main(String[] args)
   {
      // Tablica zawierająca nazwiska nauczycieli 
      // posortowana w kolejności alfabetycznej
      String[] names = {  "Haręda", "Hibsz",
                          "Hołdys", "Krasiński",
                          "Lipińska", "Piątek" };
   
      // Tablica równoległa zawierająca numery telefonów
      String[] phones = { "555-678-323", "555-019-459",
                          "555-997-674", "555-237-627",
                          "555-777-432", "555-171-996" };
                           
      // Zamienna, w której zapiszemy szukane nazwisko
      String searchName;
      
      // Zmienna, w której zapiszemy indeks, pod którym znajduje się nazwisko
      int index;
      
      // Zmienna sterująca pętlą
      String again = "T";
       
      // Tworzymy obiekt Scanner, aby odczytać dane wprowadzone na klawiaturze
      Scanner keyboard = new Scanner(System.in);
       
      while (again.equalsIgnoreCase("T"))
      {
         // Pobieramy szukane nazwisko
         System.out.print("Wprowadź nazwisko, które chcesz wyszukać.");
         searchName = keyboard.nextLine();
         
         // Szukamy wskazanego nazwiska
         index = binarySearch(names, searchName);
         
         if (index != -1)
         {
            // Wyświetlamy numer telefonu
            System.out.println("Numer telefonu: " + phones[index]);
         }
         else
         {
            // Nie znaleźliśmy nazwiska w tablicy
            System.out.println(searchName + " nie został znaleziony.");
         }
         
         // Wyszukać ponownie?
         System.out.print("Czy chcesz ponownie wyszukać nazwisko? (T = Tak, N = Nie)");
         again = keyboard.nextLine();
      }
   }
   
   //   Metoda binarySearch wykonuje na tablicy łańcuchów znakowych
   //   sortowanie binarne; algorytm wyszukuje w tablicy łańcuch przekazany jako argument;
   //   gdy łańcuch zostanie odnaleziony w tablicy, funkcja zwraca
   //   indeks tego elementu. W przeciwnym razie funkcja zwraca -1,
   //   co oznacza, że wskazanego łańcucha nie udało się odnaleźć w tablicy

   public static int binarySearch(String[] array, String value)
   {
      int first;       // Indeks pierwszego elementu
      int last;        // indeks ostatniego elementu
      int middle;      // Indeks środkowego elementu
      int position;    // Indeks elementu, w którym znajduje się szukana wartość
      boolean found;   // Flaga

      // Ustawiamy wartości początkowe
      first = 0;
      last = array.length - 1;
      position = -1;
      found = false;

      // Wyszukujemy wartość
      while (!found && first <= last)
      {
         // Obliczamy indeks środkowego elementu
         middle = (first + last) / 2;
         
         // Sprawdzamy, czy szukana wartość jest zapisana w środkowym elemencie...
         if (array[middle].equals(value))
         {
            found = true;
            position = middle;
         }
         // ...jeśli nie, to wartość może się znajdować w pierwszej połówce...
         else if (array[middle].compareTo(value) > 0)
            last = middle - 1;
         // ...jeśli nie, to wartość może się znajdować w drugiej połówce tablicy
         else
            first = middle + 1;
      }

      // Zwracamy indeks, pod którym znajduje się szukana wartość, lub -1,
      // jeśli wartości nie udało się odszukać
      return position;
   }
}